//-------------------------------------------------------
#ifndef	_LED_H_

#define	_LED_H_

//-------------------------------------------------------
#include	"BC66F2542.h"
#include	"typedef.h"

//-------------------------------------------------------
#define	c_LED_ON				0
#define	c_LED_OFF				1

#define	c_PAIRED_LED			0x01	
#define	c_PAIRED_ON_TIME		127				//*8ms
#define	c_PAIRED_OFF_TIME		0				//*8ms
#define	c_PAIRED_TIMES			1

#define	c_UNPAIRED_LED			0x4F	
#define	c_UNPAIRED_ON_TIME		64				//*8ms
#define	c_UNPAIRED_OFF_TIME		64				//*8ms
#define	c_UNPAIRED_TIMES		0				//unlimit

#define	c_PAIRING_LED			0x41	
#define	c_PAIRING_ON_TIME		64				//*8ms
#define	c_PAIRING_OFF_TIME		64				//*8ms
#define	c_PAIRING_TIMES			0				//unlimit

#define	c_DATA_ON_TIME			10				//*8ms
#define	c_DATA_OFF_TIME			0				//*8ms
#define	c_DATA_TIMES			1

//-------------------------------------------------------
#define	led1_port				_pc3
#define	led1_dir				_pcc3

#define	led2_port				_pc4
#define	led2_dir				_pcc4

#define	led3_port				_pc5
#define	led3_dir				_pcc5

#define	led4_port				_pc6
#define	led4_dir				_pcc6
//-------------------------------------------------------
typedef struct
{
	union
	{
		u8	val;
		struct
		{
			u8 led1		: 1;
			u8 led2		: 1;
			u8 led3		: 1;
			u8 led4		: 1;
			u8 rvs		: 1;
			u8 on_off	: 1;
			u8 flsh		: 1;
			u8 en		: 1;
		}bits;			
	}flag;
	u8	on_time;
	u8	off_time;
	u8	on_off_cnt;
	u8	on_off_times;								//0 means unlimit
} _LED_STRUCT_;

//-------------------------------------------------------
extern _LED_STRUCT_ led;

//-------------------------------------------------------
void	initLEDPort(void);
void	initLEDPattern(u8 flag, u8 on_tm, u8 off_tm, u8 tms);
void	updateLED(void);
u8	    chkLEDSts(void);

#endif